<?php
// =============================================================================
// Plantilla base para las páginas
// Template Name: Contacto
// =============================================================================
?>

<?php get_header(); ?>
	

	<?php if ( have_posts() ) : ?>
		<?php while ( have_posts() ) : the_post(); ?>

			<section class="contacto hero-sin-bg">
					<div class="container">
						<div class="row">
							<div class="col-xs-12">
								<h1><?php the_title(); ?></h1>
							</div>
						</div>
					</div>
				</section>
			<section class="contacto-txt">
				<?php 
				// vars
				$latitud = get_field('mapa_latitud');
				$longitud = get_field('mapa_longitud');
				$titulo = get_field('titulo_mapa');
				$info = get_field('info_block_left');
				?>
				<div class="container">
					<div class="row row-height">
					    <div class="col-xs-12 col-md-8 tr-left col-height">
						    <div id="mapa-contacto" class="mapa-contacto" data-latitud="<?php echo $latitud; ?>"  data-longitud="<?php echo $longitud;?>"></div>
					    </div>
					   <div class="col-xs-12 col-md-3 col-height col-r col-icons">
						   <div class="container-label">
								<span>01</span>	
								<span><?php _e('Oficinas','crepesandtheme') ?></span>
							</div>		
							<h2><?php echo $titulo; ?></h2>	
							<?php echo $info; ?>
							<div class="phone">
								<?php if (get_field("phone")){ ?>
									<span class="icon-telefono"></span>
									<a href="tel:<?php echo the_field('phone'); ?>"><?php _e('+','crepesandtheme') ?><?php the_field('phone'); ?></a>
								<?php } ?>
							</div>
							<div class="web">
								<?php if (get_field("web")){ ?>
									<span class="icon-world"></span>								
									<a href="<?php echo the_field('web'); ?>" target="blank"><?php the_field('web'); ?></a>
								<?php } ?>
							</div>
							<div class="email">
								<?php if (get_field("email")){ ?>
									<span class="icon-email"></span>
									<a href="mailto:<?php echo the_field('email'); ?>"><?php the_field('email'); ?></a>
								<?php } ?>
							</div>
						</div>
					    <div class="col-xs-12 col-md-1"></div>
				    </div>	
				</div>
			</section>

		<?php endwhile; ?>
	<?php endif; ?>
	
	<script>
	function initMap() {	          
	    jQuery(".mapa-contacto").each(function(){
			var latitud = parseFloat(jQuery(this).attr("data-latitud"));
			var longitud = parseFloat(jQuery(this).attr("data-longitud"));
		    var idMapa = jQuery(this).attr("id");

			var mapaArray = [
			    [latitud, longitud, idMapa],
			];
	        		        
	        for (i = 0; i < mapaArray.length; i++) {
	                
		        // Definimos las variables latitud y longitud
	 	        var coordenadas = {lat: mapaArray[i][0], lng: mapaArray[i][1]};
				//var coordenadas = {lat: 40.4381311, lng: -3.671385};
		
				// Mapa + Centrado con Latitud y Longitud
				var map = new google.maps.Map(document.getElementById(mapaArray[i][2]), {
					center: coordenadas,
					zoom: 14,
					disableDefaultUI: true,
					styles: [
					    {
					        "featureType": "all",
					        "elementType": "labels.text.fill",
					        "stylers": [
					            {
					                "saturation": 36
					            },
					            {
					                "color": "#333333"
					            },
					            {
					                "lightness": 40
					            }
					        ]
					    },
					    {
					        "featureType": "all",
					        "elementType": "labels.text.stroke",
					        "stylers": [
					            {
					                "visibility": "on"
					            },
					            {
					                "color": "#ffffff"
					            },
					            {
					                "lightness": 16
					            }
					        ]
					    },
					    {
					        "featureType": "all",
					        "elementType": "labels.icon",
					        "stylers": [
					            {
					                "visibility": "off"
					            }
					        ]
					    },
					    {
					        "featureType": "administrative",
					        "elementType": "geometry.fill",
					        "stylers": [
					            {
					                "color": "#fefefe"
					            },
					            {
					                "lightness": 20
					            }
					        ]
					    },
					    {
					        "featureType": "administrative",
					        "elementType": "geometry.stroke",
					        "stylers": [
					            {
					                "color": "#fefefe"
					            },
					            {
					                "lightness": 17
					            },
					            {
					                "weight": 1.2
					            }
					        ]
					    },
					    {
					        "featureType": "landscape",
					        "elementType": "geometry",
					        "stylers": [
					            {
					                "color": "#f3f5fa"
					            },
					            {
					                "lightness": 20
					            }
					        ]
					    },
					    {
					        "featureType": "poi",
					        "elementType": "geometry",
					        "stylers": [
					            {
					                "color": "#f5f5f5"
					            },
					            {
					                "lightness": 21
					            }
					        ]
					    },
					    {
					        "featureType": "poi.park",
					        "elementType": "geometry",
					        "stylers": [
					            {
					                "color": "#dedede"
					            },
					            {
					                "lightness": 21
					            }
					        ]
					    },
					    {
					        "featureType": "road.highway",
					        "elementType": "geometry.fill",
					        "stylers": [
					            {
					                "color": "#ffffff"
					            },
					            {
					                "lightness": 17
					            }
					        ]
					    },
					    {
					        "featureType": "road.highway",
					        "elementType": "geometry.stroke",
					        "stylers": [
					            {
					                "color": "#ffffff"
					            },
					            {
					                "lightness": 29
					            },
					            {
					                "weight": 0.2
					            }
					        ]
					    },
					    {
					        "featureType": "road.arterial",
					        "elementType": "geometry",
					        "stylers": [
					            {
					                "color": "#ffffff"
					            },
					            {
					                "lightness": 18
					            }
					        ]
					    },
					    {
					        "featureType": "road.local",
					        "elementType": "geometry",
					        "stylers": [
					            {
					                "color": "#ffffff"
					            },
					            {
					                "lightness": 16
					            }
					        ]
					    },
					    {
					        "featureType": "transit",
					        "elementType": "geometry",
					        "stylers": [
					            {
					                "color": "#f2f2f2"
					            },
					            {
					                "lightness": 19
					            }
					        ]
					    },
					    {
					        "featureType": "water",
					        "elementType": "geometry",
					        "stylers": [
					            {
					                "color": "#ffffff"
					            },
					            {
					                "lightness": 17
					            }
					        ]
					    }
					]
				});
		
				// Marcador
				var marker = new google.maps.Marker({
		          position: coordenadas,
		          map: map,
		          icon: '<?php echo get_template_directory_uri(); ?>/img/location-map.png'
		        });  
		    } 
		});      
	}

	jQuery(document).ready(function(){
		jQuery(".nav-tabs a").click(function(){
	        jQuery(this).tab('show');
	    });
	    jQuery('.nav-tabs a').on('shown.bs.tab', function(event){
	        initMap(); // google map init function
	    });
	});
	    

  
    </script>
    
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCQOwMgg6OHOSa-4vhiVbe0mCJMWs1f-gk&callback=initMap"></script>


<?php // dynamic_sidebar( 'barra_lateral' ); ?>

<?php get_footer(); ?>