
var devicewidth = jQuery(window).width();
jQuery(document).ready(function() {
			
/* RESPONSIVE
*********************************************************************/
if ( devicewidth < 992 ) {
	//Menor de 922
	//menuDesktop();
	buttonAccesoMovil();
	if ( devicewidth > 768 ) {
		//Entre 992 y 768
		//desktop();
		buttonAccesoMovil();
	} else {
		//Menor de 768
		//mobile();
		buttonAccesoMovil();
	}
}else {
	//Mayor de 922
	//desktop();
	buttonAccesoDesktop();
}

/* RESIZE
*********************************************************************/
jQuery(window).resize(function() {
	
	var widthChanged = false;
	
    if ( jQuery(window).width() != devicewidth ) {
        widthChanged = true;
    }

	if ( widthChanged == true ) {
					
		if ( jQuery(window).width() < 992 ) {
			//Menor de 922
			//menuDesktop();
			buttonAccesoMovil();
			if ( jQuery(window).width() > 768 ) {
				//Entre 992 y 768
				//desktop();
				buttonAccesoMovil();
			} else {
				//Menor de 768
				//mobile();
				buttonAccesoMovil();
			}
		}else {
			//Mayor de 922
			//desktop();
			buttonAccesoDesktop();
		}	
	}		
});


/* MOVER ELEMENTOS DE LUGAR
*********************************************************************/
function buttonAccesoDesktop(){
	jQuery('.ac-participantes').insertAfter('header .container.container-movil');
	jQuery('.ac-publica').insertAfter('header .container.container-movil');
}
function buttonAccesoMovil(){
	jQuery('.ac-participantes').insertAfter('header .nav .idioma');
	jQuery('.ac-publica').insertAfter('header .nav .idioma');
}


/* GRÁFICA CONTADOR + GIF
*********************************************************************/
var a = 0;
	
if(jQuery('.bloque-grafica').length){
	jQuery(window).scroll(function() {	
		var scrollWindow = jQuery(window).scrollTop()
		var topBloqueCount = jQuery('.count').offset().top - jQuery(window).innerHeight() ;
		
	    if( a == 0 && scrollWindow >= topBloqueCount){
      
			jQuery('.count').each(function () {
			    jQuery(this).prop('Counter',0).animate({
			        Counter: jQuery(this).text()
			    }, {
			        duration: 2000,
			        easing: 'swing',
			        step: function (now) {
			            var mynum = jQuery(this).text(Math.ceil(now*10)/10);
			        }
			    });
			});	
			
		   	jQuery(".container-grafica").each(function () {
			   	var src = jQuery(this).find("img").attr("src");
				jQuery(this).find("img").attr("src", src);
			});	

			a = 1;	         
	    }
	});			
}
	
	
/* REJILLA
*********************************************************************/
function rejillaDesktop() {
	jQuery(".rejilla").html("");
	for(i = 1; i < 9 ; i++) { 
		jQuery(".rejilla").append("<div class='r-with'></div>");
	}
}	
function rejillaTablet() {
	jQuery(".rejilla").html("");
	for(i = 1; i < 5 ; i++) { 
		jQuery(".rejilla").append("<div class='r-with'></div>");
	}
}	
function rejillaMovil() {
	jQuery(".rejilla").html("");
	for(i = 1; i < 4 ; i++) { 
		jQuery(".rejilla").append("<div class='r-with'></div>");
	}
}


/* CAMBIO MENU COLOR
*********************************************************************/
function headerCambioColor(){
		var scroll = jQuery(window).scrollTop();
				
		if ( scroll > 25 || jQuery("body").hasClass("page-template-page-comunicados-oficiales") || jQuery("body").hasClass("page-template-template-atencion-cliente")  || jQuery("body").hasClass("page-template-page-informacion-relevante") || jQuery("body").hasClass("page-template-default") ) {
			jQuery("header").addClass("scrolling");
			jQuery("header .container .nav .menu-menu-principal-container ul li a").addClass("active");
		}
		else{
			jQuery("header").removeClass("scrolling");
			jQuery("header .container .nav .menu-menu-principal-container ul li a").removeClass("active");
		}
	}
	
	headerCambioColor();

	jQuery(window).scroll(function () {
		headerCambioColor();
	});	


/* SCROLL HERO
*********************************************************************/
jQuery( ".home .bloque-slider .scroll" ).on('click', function(){
	var altoHero = jQuery('.slider-principal').height();
	jQuery("html,body").animate( { scrollTop: altoHero} , 1500 );
});


/* MENU MOVIL
*********************************************************************/
jQuery("header .cabecera .menu-abrir, .bg-container-movil").on('click', function(){
    jQuery(".container-movil").toggleClass("container-movil-visible");
    jQuery(".bg-container-movil").toggleClass("bg-container-movil-visible");
    jQuery("header .cabecera").toggleClass("cabecera-white");
    jQuery("body").toggleClass("no-scroll");
});
	

/* MOSTRAR / OCULTAR IDIOMA
*********************************************************************/
jQuery(".nav .idioma").on('click', function(){
	jQuery(".nav .language-chooser").toggleClass("mostrar-lenguage");
});	


/* SLICK SLIDER
*********************************************************************/
jQuery('.slider-principal').slick({
	slidesToShow: 1,
	slidesToScroll: 1,
	dots: true,
	infinite: true,
	fade: true,
	arrows: false
});

//--- Contador Carrusel Actual
jQuery('.home .bloque-slider').on('afterChange', function(event, slick, currentSlide, nextSlide){
	var currenSlideActual = currentSlide + 1
   jQuery(".bloque-slider .controles-carrusel .currenSlide").text("0" + currenSlideActual);
});	
jQuery('.home .bloque-conocenos').on('afterChange', function(event, slick, currentSlide, nextSlide){
	var currenSlideActual = currentSlide + 1
   jQuery(".bloque-conocenos .controles-carrusel .currenSlide").text("0" + currenSlideActual);
});

//--- Contador Carrusel TOTAL
var currenTotal = jQuery(".slider-principal .slick-slide").length;
jQuery(".bloque-slider .controles-carrusel .curren-total").text("0" + currenTotal );


/* AVISO DE COOKIES
*********************************************************************/
function createCookie(name, value, days) {
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        var expires = "; expires=" + date.toGMTString();
    }
    else var expires = "";

    document.cookie = name + "=" + value + expires + "; path=/";
}

function readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
}

function eraseCookie(name) {
    createCookie(name, "", -1);
}
	
function checkCookie() {			
	var genC = readCookie('cimd');
	if ( !genC ) {
		jQuery( '.cookies' ).fadeIn();
		setTimeout(
			function() {
				jQuery( '.cookies' ).fadeOut();
				createCookie('cimd', true, 365);
			}, 100000
		);
	}
	
	jQuery( '.cookies .cerrar, .cookies .btn' ).on( 'click', function(){
		createCookie('cimd', true, 365);
		jQuery( '.cookies' ).fadeOut();
	});	 
}

checkCookie();
	
});