<?php
/*
*   =================================================================================================
*   TU_CPT
*   Custom Post Type
*   =================================================================================================
*/
function registrar_cpt_project() { // Como ejemplo hemos usado un CPT imaginario "Project"
    $args = array (
        'has_archive' => true,
        'label' => 'Projects',
        'labels' => array (
            'add_new' => 'Añadir nuevo',
            'add_new_item' => 'Añadir nuevo Project',
            'new_item' => 'Nuevo Project'
        ),
        'menu_icon' => 'dashicons-hammer', // Más iconos en https://developer.wordpress.org/resource/dashicons/
        'menu_position' => 4,
        'public' => true,
        'show_in_menu' => false,
        'show_in_nav_menus' => true,
        'supports' => array('title','thumbnail'),
        'taxonomies' => array( 'taxonomia'), // Tiene que coincidir con la taxonomía registrada en la última línea: register_taxonomy( 'taxonomia', array( 'project' ), $args );
    );
    register_post_type('project', $args);

    flush_rewrite_rules();
};

add_action('init','registrar_cpt_project');

/*
*   =================================================================================================
*   TU_CTX
*   Custom Taxonomie
*   =================================================================================================
*/

// hook into the init action and call create_book_taxonomies when it fires
add_action( 'init', 'create_projects_taxonomie', 0 );

// create one taxonomie
function create_projects_taxonomie() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => _x( 'Tipos', 'taxonomy general name' ),
        'singular_name'     => _x( 'Tipo', 'taxonomy singular name' ),
        'search_items'      => __( 'Buscar Tipos' ),
        'all_items'         => __( 'Todos los Tipos' ),
        'parent_item'       => __( 'Padre Tipos' ),
        'parent_item_colon' => __( 'Padre Tipos:' ),
        'edit_item'         => __( 'Editar Tipo' ),
        'update_item'       => __( 'Actualizar Tipo' ),
        'add_new_item'      => __( 'Añadir nuevo Tipo' ),
        'new_item_name'     => __( 'Nuevo nombre Tipo' ),
        'menu_name'         => __( 'Tipos de Project' ),
    );

    $args = array(
        'hierarchical'      => true, // Si ponemos "false" sería una taxonomía de tipo Tag, no jerárquica
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        //'rewrite'           => array( 'slug' => 'projects' ), // El slug de tu taxonomía
    );

    register_taxonomy( 'taxonomia', array( 'project' ), $args );
}



// This is the end...
// My only friend,
// The end!!
?>