<?php
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// CONFIGURACIÓN WP
// Aquí añadimos nuestras propias funciones de Wordpress
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// CAMBIAR mensaje de error del login
// Así evitamos dar pistas a los malos
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
function login_errors_message() {
    return 'Vaya! creo que has hecho algo mal...';
}
add_filter('login_errors', 'login_errors_message');

// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// ELIMINAR “basura” del <head>
// (Versión de WordPress, RSD, Windows Live Writter, etc.)
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'index_rel_link');
remove_action('wp_head', 'parent_post_rel_link', 10, 0);
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);

// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// DESACTIVAR código HTML de los comentarios
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
add_filter('pre_comment_content', 'wp_specialchars');

// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// AÑADIR el slug de las páginas como class en el body
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
function add_slug_body_class( $classes ) {
	global $post;
	if ( isset( $post ) ) {
		// en este caso añade el tipo de post más "-" más el nombre de la página 
		$classes[] = $post->post_type . '-' . $post->post_name;
	}
	return $classes;
}
add_filter( 'body_class', 'add_slug_body_class' );

// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// AÑADIR el código del idioma como class en el body
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
add_filter('body_class', 'my_custom_body_class', 10, 2);
function my_custom_body_class($classes) {
	$classes[] = get_bloginfo('language');
	return $classes;
}
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// Genera un slug de un literal
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
function cleaned($string, $replace = array(), $delimiter = '-') {
  // https://github.com/phalcon/incubator/blob/master/Library/Phalcon/Utils/Slug.php
  if (!extension_loaded('iconv')) {
    throw new Exception('iconv module not loaded');
  }
  // Save the old locale and set the new locale to UTF-8
  $oldLocale = setlocale(LC_ALL, '0');
  setlocale(LC_ALL, 'en_US.UTF-8');
  $clean = iconv('UTF-8', 'ASCII//TRANSLIT', $string);
  if (!empty($replace)) {
    $clean = str_replace((array) $replace, ' ', $clean);
  }
  $clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
  $clean = strtolower($clean);
  $clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);
  $clean = trim($clean, $delimiter);
  // Revert back to the old locale
  setlocale(LC_ALL, $oldLocale);
  return $clean;
}

// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// Añadimos un campo excerpt en nuestras páginas
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
add_post_type_support( 'page', 'excerpt' );

// ----------------------------------------------------------------------------------------------------------------------------------------------------------
// Quitar menús del admin de WordPress
// ----------------------------------------------------------------------------------------------------------------------------------------------------------
function remove_menus(){
  
  remove_menu_page( 'edit.php' );                   //Entradas
  remove_menu_page( 'edit-comments.php' );          //Comentarios
  
}
add_action( 'admin_menu', 'remove_menus' );


// This is the end...
// My only friend,
// The end!!
?>