<?php

/**
* Crepes&Theme by Crepes&Texas (http://www.crepesandtexas.com/)
* The template base for displaying the Site Header: header.php
*
* @package WordPress
* @subpackage crepesandtheme
*/

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">

		<title><?php wp_title(''); ?><?php if(wp_title('', false)) { echo ' :'; } ?> <?php bloginfo('name'); ?></title>

		<link href="//www.google-analytics.com" rel="dns-prefetch" >
		<link href="<?php echo get_template_directory_uri(); ?>/humans.txt" rel="author">

        <!-- FAVICONS => http://www.favicon-generator.org/ -->
        <link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-57x57.png">
		<link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-60x60.png">
		<link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-72x72.png">
		<link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-76x76.png">
		<link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-114x114.png">
		<link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-120x120.png">
		<link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-144x144.png">
		<link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-152x152.png">
		<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-icon-180x180.png">
		<link rel="icon" type="image/png" sizes="192x192"  href="<?php echo get_template_directory_uri(); ?>/img/icons/android-icon-192x192.png">
		<link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="96x96" href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon-96x96.png">
		<link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon-16x16.png">
		<link rel="manifest" href="<?php echo get_template_directory_uri(); ?>/img/icons/manifest.json">
		<meta name="msapplication-TileColor" content="#ffffff">
		<meta name="msapplication-TileImage" content="<?php echo get_template_directory_uri(); ?>/img/icons/ms-icon-144x144.png">

		<!-- Chrome, Firefox OS and Opera -->
		<meta name="theme-color" content="#ffffff">
		<!-- Windows Phone -->
		<meta name="msapplication-navbutton-color" content="#ffffff">
		<!-- iOS Safari -->
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="<?php bloginfo('description'); ?>">
		
		<meta name="format-detection" content="telephone=no">

		<!-- Gráficas-->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.1/Chart.bundle.js"></script>
		
		<?php wp_head(); ?>

		<?php // if((defined('WP_DEVELOPMENTMODE') && WP_DEVELOPMENTMODE )): ?>
		
		<!-- Analytics -->
		<script>
			(function(f,i,r,e,s,h,l){i['GoogleAnalyticsObject']=s;f[s]=f[s]||function(){
				(f[s].q=f[s].q||[]).push(arguments)},f[s].l=1*new Date();h=i.createElement(r),
				l=i.getElementsByTagName(r)[0];h.async=1;h.src=e;l.parentNode.insertBefore(h,l)
			})(window,document,'script','//www.google-analytics.com/analytics.js','ga');
			ga('create', 'UA-XXXXXXXX-XX', 'yourdomain.com');
			ga('send', 'pageview');
		</script>
		<!-- Fin del Analytics -->

		<?php // endif; ?>

	</head>
	
	<body <?php body_class(); ?>>
		<?php if (!is_page(368) or is_page(210) ){?>
			<div id="guides">
				<div class="guide guide1"></div>
				<div class="guide guide2"></div>
				<div class="guide guide3"></div>
				<div class="guide guide4"></div>
				<div class="guide guide5"></div>
				<div class="guide guide6"></div>
				<div class="guide guide7"></div>
			</div>
		<?php } ?>
		<header role="banner" class="<?php if( get_field('cabecera_white') ): ?> fixed <?php endif; ?>">	
			<div class="cabecera">	
				<div class="logo">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
						<img class="img-responsive logo-white" src="<?php echo get_template_directory_uri(); ?>/img/GrupoCimd-otf.png" alt="Logo Cimd"/>
						<img class="img-responsive logo-scrolling" src="<?php echo get_template_directory_uri(); ?>/img/GrupoCimd-otf.png" alt="Logo Cimd"/>
					</a>
				</div>
				<span class="menu-abrir icon-hamburguesa"></span>
				<span class="menu-abrir icon-cerrar"></span>
			</div>
			<div class="container container-movil">
				<nav class="nav" role="navigation">
					<?php wp_nav_menu( array( 'theme_location' => 'main' ) ); ?>
					<span class="idioma">
						<?php echo qtranxf_generateLanguageSelectCode();  ?>
					</span>
					<p class="text-movil">Grupo CIMD   -   Príncipe de Vergara 131. 3ª Planta. 28002 Madrid  -  91 432 64 00  -  Web by</p>
				</nav>
			</div>
			<?php if (is_page(546)){?>
				<div class="ac-participantes">
					<a class="btn btn-terciario" href="https://otf.cimdsv.com/cds/#/login"><?php _e('Participantes','crepesandtheme') ?></a>
				</div>
				<div class="ac-publica">
					<a class="btn btn-principal" href="https://fpp.cimdsv.com/admin/login/?next=/admin/"><?php _e('Pública','crepesandtheme') ?></a>
				</div>	
			<?php } ?>
			<div class="container bg-container-movil"></div>
		</header>

		<!-- Contenido (Main + Sidebar) -->
		<div class="contenido-paginas">